/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2012 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.

**************************************************************************/


// *********** GLOBAL VARS *****************************

var helpDoc = MM.HELP_objAudio;

var AUDIO_SRC1;
var AUDIO_SRC2;
var AUDIO_SRC3;

var gAudioTag;
var gAudioHTMLTag;


// ******************** API ****************************

function canInspectSelection(){
  return true;
}

function inspectSelection(){

	
	gAudioTag = null;
	var theDOM = dw.getDocumentDOM(); 
    var theObj = getSelectedNode(); 

    // Get the value id. 	
    var aID = theObj.getAttribute('id'); 
	// update all the fields
	if( aID )
		document.topLayer.document.audioID.editText = aID;
	else
		document.topLayer.document.audioID.editText = "";

    populateIdList( aID );

	// Update the title	
	var title = theObj.getAttribute('title');
	if( title )
		document.topLayer.document.title.value = title;
	else
		document.topLayer.document.title.value = "";	
     
	var controls = theObj.getAttribute('controls');
	
	var muted = theObj.getAttribute('muted');
	
	var autoplay = theObj.getAttribute('autoplay');

	var loop = theObj.getAttribute('loop');

	if( controls )
		document.bottomLayer.document.controls.checked = true;
	else
		document.bottomLayer.document.controls.checked = false;

	if( muted )
		document.bottomLayer.document.muted.checked = true;
	else
		document.bottomLayer.document.muted.checked = false;
		
	if( autoplay )
		document.bottomLayer.document.autoplay.checked = true;
	else
		document.bottomLayer.document.autoplay.checked = false;	

	if( loop )
		document.bottomLayer.document.loopAudio.checked = true;
	else
		document.bottomLayer.document.loopAudio.checked = false;

	// Update the preload tag
	var preloadval = theObj.getAttribute('preload');
	var selIdx = 0;
	if( preloadval ){
		if( preloadval == "none" )
			selIdx = 0;
		else if( preloadval == "auto" )
			selIdx = 1;
		else
			selIdx = 2;
	}
	document.bottomLayer.document.preload.selectedIndex = selIdx; 
	// Now update the sources
	updateSourceFields();
	// populate classes
	populateClassList();
	var classSel = document.getElementById('classList');
	if(classSel)
	{
		var cl = theObj.getAttribute('class');
		if(cl)
		{
			var allclasses = getClasses();
			if(allclasses)
			{
				classSel.selectedIndex = allclasses.indexOf(cl) + 1;				
			}
			else{
				classSel.selectedIndex = 0;
			}
		}
		else{
			classSel.selectedIndex = 0;
		}
	}
	//set the source
	if(isOnlyInlineSourcePresent())
	{
		setInlineSourceAsPrimarySource();
	}
	
}

// ******************** LOCAL FUNCTIONS ****************************

function _updateSourceTags()
{

	AUDIO_SRC1 = null;
	AUDIO_SRC2 = null;
	AUDIO_SRC3 = null;

	var theObj = getSelectedNode(); 
	if( theObj ){

		var selectedNode = new TagEdit( theObj.outerHTML);
		gAudioTag     = theObj;
		gAudioHTMLTag = selectedNode;
		var childNodes = selectedNode.getChildNodes();
		var isPtagFound = false;
		
		if( childNodes ){

			var numChild = childNodes.length;
			if( numChild > 0 ){

				var i = 0;
				for( var j = 0; j < numChild ; j++ ){
					if( childNodes[j].getTagName() == "SOURCE" && i < 3){
						
						if( i == 0  ){
							AUDIO_SRC1 = childNodes[j];
							i++;
						}
						else if( i == 1 ){
							AUDIO_SRC2 = childNodes[j];
							i++;
						}
						else if( i == 2 ){
							AUDIO_SRC3 = childNodes[j];
							i++;
						}
						
					}
					else if(childNodes[j].getTagName() == "P")
					{
						isPtagFound = true;
						var defaulttext = childNodes[j].getInnerHTML();
						if(defaulttext)
						{						
							if(defaulttext != document.topLayer.document.defaulttext.value)
							{
								document.topLayer.document.defaulttext.value = defaulttext;
							}							
						}
						else
						{
							document.topLayer.document.defaulttext.value = '';
						}
					}// childNodes[i].getTagName() == "SOURCE"
				} // for loop
			} // numChild
		}// childNodes
		if( !isPtagFound )
		{
			document.topLayer.document.defaulttext.value = '';
		}
	} // theObj;
}
 
function setDefaultText()
{
	
	var defText = document.topLayer.document.defaulttext.value ;
	var theObj = getSelectedNode(); 
	
	if( theObj  ){
		var selectedNode = new TagEdit( theObj.outerHTML);
		var childNodes = selectedNode.getChildNodes();
		if(defText && defText != "")
		{
			if( childNodes ){
				var i=0 ;
				var numChild = childNodes.length;
				if( numChild > 0 ){
					for( var j = 0; j < numChild ; j++ ){							
						if( childNodes[j].getTagName() == "P" ){
							i++;
							childNodes[j].setInnerHTML(defText);							
							break;
						}
					}
				}
				if(i==0)
				{
					defaulttextTag = new TagEdit("<p>"+ defText + "</p>");
					childNodes.push(defaulttextTag);
				}
			}
			gAudioHTMLTag.setChildNodes(childNodes);
		}
		else
		{
			if( childNodes ){
				var numChild = childNodes.length;
				if( numChild > 0 ){
					var newChildNodes = Array();
					for( var j = 0; j < numChild ; j++ ){
						if( childNodes[j].getTagName() != "P" ){
							newChildNodes.push(childNodes[j])
						}
					}
				}				
			}
			gAudioHTMLTag.setChildNodes(newChildNodes);
		}
		var updateText = gAudioHTMLTag .getOuterHTML();
		updateObjOuterHTML(updateText);
		
	}
}

function updateObjOuterHTML(updateText)
{
	var theObj = getSelectedNode();
	if( theObj )
    {				
		theObj.outerHTML = updateText;
		return true;
	}
	return false;
}

function updateUsageTrackingForAllSourcesUsed()
{
	// log the event for head light tracking
   	dw.logEvent(UT_HTML5_AUDIO, UT_HTML5_AUDIO_ALL_SOURCES_INSERTED);
}
function updateSourceField(sourceField, sourceFieldValue)
{

	var someStr = '';
	if( sourceField ){

		var src1 = null;
		src1 = sourceField.getAttribute('src');
		if( src1 ){
			sourceFieldValue.value = src1;
		}
		else
			sourceFieldValue.value = someStr;
	}
	else
		sourceFieldValue.value = someStr;
}

// Call this function after every source tag insert or
// source tag attribute change.

function updateSourceFields()
{	
	// Update our source tags
	_updateSourceTags();
	// Now call each source field
	updateSourceField(AUDIO_SRC1, document.topLayer.document.source1);
	updateSourceField(AUDIO_SRC2, document.bottomLayer.document.source2);
	updateSourceField(AUDIO_SRC3, document.bottomLayer.document.source3);
	
}

function getSelectedNode()
{
	// Get the DOM of the current document. 
    var theDOM = dw.getDocumentDOM(); 
	// Get the selected node. 
    var theObj;
	if( theDOM )
		theObj  = theDOM.getSelectedNode(); 
	// return the selected node
	
	if( theObj != null && theObj.tagName.toUpperCase() != "AUDIO")
	{	
		//in cases where the selection spans outside audio tag, audio tag's parent is the selected node
		//here we locate the audio tag amongst the children
		if(theObj.childNodes)
		{
			for(var i=0; i<theObj.childNodes.length; i++)
			{
				var tagName = theObj.childNodes[i].tagName;
				if( tagName && tagName.toUpperCase() == "AUDIO")
				{
					theObj = theObj.childNodes[i];
					break;
				}
			}
		}
	}
	return theObj;
}
// passing null to this will remove the attribute
// from the audio tag.
function setOrRemoveAttribute(attrName, attrValue)
{
	// set the attribute name. if the attrValue
	// is null then remove that attribute from the audio tag.
	if( attrName ){
		var theNode = getSelectedNode();
		if( theNode ){
			// Set the attribute value if present or
			// remove the attribute if not present.
			if( attrValue )
			{
				theNode.setAttribute(attrName,attrValue);
				modifyAudioTag();
			}
			else
				theNode.removeAttribute(attrName);
		}
	}
}

function removeAttr(attrName)
{   
	var theObj = getSelectedNode();
	if( theObj ){
		theObj.removeAttribute(attrName);
	}
}

function isIDInUse(idStr)
{
	var dom = dw.getDocumentDOM();
	if (dom && idStr)
	{	
		var nodeList = dom.getElementsByAttributeName('id');
		if (nodeList)
		{
			for (var i = 0; i < nodeList.length; i++)
			{
			  var nodeId = nodeList[i].getAttribute('id');
				if (nodeId && (nodeId.toLowerCase() == idStr.toLowerCase()))
					return true;
			}
		}
	}
	return false;
}

function getClasses()
{
	var dom = dw.getDocumentDOM();
	if (dom)
	{
		allClasses = dom.getSelectorsDefinedInStylesheet('class');
			
		for (i = 0; i < allClasses.length; i++)
		{
			if (allClasses[i][0] == '.')
			allClasses[i] = allClasses[i].slice(1);
		}
		return allClasses;
	}
	return null;
}
function isSame(array1, array2)
{
	if(array1 && array2 )
	{
		if(array1.length != array2.length)
			return false;
		for(var i=0 ; i<array1.length ; i++ )	
		{
			if(array1[i]!=array2[i])
			{
				return false;
			}
		}
		return true;
	}
	if(!array1 && !array2)
	{
		return true;
	}
	return false;
}
function populateClassList()
{
	   var dom = dw.getDocumentDOM();
	   var none = dw.loadString("Inspectors/text/classoption/none");
	   if (dom)
	   {
			var allClasses = getClasses();
			if( allClasses && allClasses.length > 0)
			{
				var alreadyAddedClasses = new Array();
				var classOptions = document.topLayer.document.classList.options;
				if(classOptions && alreadyAddedClasses)
				{
					for(var i=1 ; i<classOptions.length ; i++)
					{
						alreadyAddedClasses.push(classOptions[i].text);
					}
					if( !isSame(allClasses, alreadyAddedClasses) )
					{
						classOptions.disableUpdates();
						for(var i=classOptions.length-1 ; i>0 ; i--)
						{
							classOptions[i] = null;							
						}
						if(allClasses)
						{
							for( var i = 0; i < allClasses.length ; i++) {
								var theOption = new Option;
								if(theOption)
								{		
									theOption.text = allClasses[i];
									theOption.value = allClasses[i];	
									classOptions[i+1] = theOption;
								}
							}
						}
						classOptions.enableUpdates();
						var theOption = new Option;	
						if(theOption)
						{	
							theOption.text = none;
							theOption.value = "none";	
							classOptions[0] = theOption;
						}
					}
				}
			}
			else
			{
				var classOptions = document.topLayer.document.classList.options;
				if(classOptions && classOptions.length>1)
				{
					classOptions.disableUpdates();
					for(var i=classOptions.length-1 ; i>0 ; i--)
					{						
						classOptions[i] = null;						
					}
					classOptions.enableUpdates();
					var theOption = new Option;	
					if(theOption)
					{	
						theOption.text =none;
						theOption.value ="none";	
						classOptions[0] = theOption;
						classOptions.length=1;
					}					
				}
				
			}
		}
}

function populateIdList(id)
{
	   var dom = dw.getDocumentDOM();
	   if (dom)
	   {
			var allIds = getIDs();
			if( allIds && allIds.length > 0)
			{
				var alreadyAddedIDs = new Array();
				var IDOptions = document.topLayer.document.audioID.options;
				if(IDOptions && alreadyAddedIDs)
				{
					var i=0;
					if(id)
						i++;
					for( ; i<IDOptions.length ; i++)
					{
						alreadyAddedIDs.push(IDOptions[i].text);
					}
					if( !isSame(allIds, alreadyAddedIDs) )
					{
						IDOptions.disableUpdates();
						for(var i=IDOptions.length-1 ; i>=0 ; i--)
						{						
							IDOptions[i] = null;						
						}
						var curIndex =0;
						if(id)
						{	
							theOption = new Option;
							if(theOption)
							{	
								theOption.text = id;
								theOption.value = id;
								IDOptions[curIndex++] = theOption;
							}
						}
						if(allIds)
						{ 
							for( var i = 0; i < allIds.length ; i++) {
								var theOption = new Option;
								if(theOption)
								{		
									theOption.text = allIds[i];
									theOption.value = allIds[i];		
									IDOptions[curIndex++] = theOption;
								}
							}
						}
						IDOptions.enableUpdates();
						if(id)
						{
							IDOptions.selectedIndex = 0;
							IDOptions[0].selected=true;
							document.topLayer.document.audioID.editText = id;
						}
						if( id || (allIds && allIds.length >0 ) ) 
						{
							theOption = new Option;
							if(theOption)	
							{
								if(id)
								{				
									theOption.text = id;
									theOption.value = id;
								}
								else
								{
									theOption.text = allIds[0];
									theOption.value = allIds[0];
								}			
								IDOptions[0] = theOption;
							}
						}
					}
				}
			}
			else
			{
				var IDOptions = document.topLayer.document.audioID.options;
				if( IDOptions && IDOptions.length > 0)
				{
					IDOptions.disableUpdates();
					for(var i=IDOptions.length-1 ; i>0 ; i--)
					{						
						IDOptions[i] = null;						
					}
					IDOptions.enableUpdates();
					IDOptions[0] = null;
					IDOptions.length=0;
					
				}
			}
		}
}

function getIDs()
{
     var dom = dw.getDocumentDOM();
     if (dom)
     {
     	var ids = dom.getSelectorsDefinedInStylesheet('id');
	
		if(ids)
		{
			allUnusedIDs = new Array();
			for (i = 0; i < ids.length; i++)
			{
				if (ids[i][0] == '#')
					ids[i] = ids[i].slice(1);
				if (!isIDInUse(ids[i]))
					allUnusedIDs.push(ids[i]);
			}
			return allUnusedIDs;
		}
		
	 }
	 return null;
}

function findExtension(fileName)
{
	if( fileName ){
		var ext = /^.+\.([^.]+)$/.exec(fileName);
		var finalExt = ext == null ? "" : ext[1];
		return finalExt;
	}
	else
		return null;
}

function getAudioType(extension)
{
    if( !extension || extension == "" )
    {
        return "";
    }
	
	if( extension == "mp3" )
	{
		return "mp3";
	}
	if(extension == "ogg" || extension == "oga" )
	{
		return "ogg";
	}
	if(extension == "wav"  )
	{
		return "wav";
	}
	return "";
}

// pass in the file name
function isKnownFormat(fileName)
{
	var ext = findExtension(fileName);
	if( ext == "ogg" || ext == "mp3" || ext == "wav" )
		return true;
	else
		return false;
}

function alertUser()
{
	var errStr = dw.loadString("Inspectors/audio/text/invalid_file_format");
	alert(errStr);	
}

function setAudioSource( srcTag, srcField)
{
 	var finalExt = null; 
	if( isKnownFormat( srcField ) )
		finalExt = findExtension(srcField);
	
	if( srcTag  ){
		var sourceAttr = srcTag.getAttribute('src');
		// check if the sourceAttr and srcField are
		// same no need to update the DOM
		if( srcField == sourceAttr )
			return; 
		if( srcField ){
			srcTag.setAttribute('src',srcField);
			if(finalExt)			
				srcTag.setAttribute('type', "audio/" + getAudioType(finalExt));
			else
				srcTag.removeAttribute('type');	
		}
		else
		{
			if( !srcTag.getAttribute('id') && !srcTag.getAttribute('class'))
			{
				if(gAudioHTMLTag)
					gAudioHTMLTag.setChildNodes(removeChildTagEdit(srcTag,gAudioHTMLTag));
			}
			else
			{
				srcTag.removeAttribute('src');
				var mediaTag = srcTag.getAttribute('type');
				if( mediaTag )
					srcTag.removeAttribute('type');
			}
		}
	}
	else{
		if( srcField && srcField != "" ){
			srcTag = new TagEdit("<source>");
			var childNodes = gAudioHTMLTag.getChildNodes();
			srcTag.setAttribute('src', srcField );
			
			if( AUDIO_SRC1 !=null && AUDIO_SRC2 !=null && getSelectedNode())
			{
				updateUsageTrackingForAllSourcesUsed();	
			}
			// find the position and set the new child
			var newChildNodes = new Array();
			var i=0;
			if(childNodes)
			{
				for( ; i<childNodes.length; i++)
				{
					if( childNodes[i].getTagName() == "SOURCE" )
					{
						newChildNodes.push(childNodes[i]);				
					}
					else
					{
						break;
					}
				}
			}
			newChildNodes.push(srcTag);
			if(childNodes)
			{
				for( i=0 ; i<childNodes.length; i++)
				{
					var tagName = childNodes[i].getTagName() ;
					if( tagName && tagName != "SOURCE" )
						newChildNodes.push(childNodes[i]);
				}			
			}			
			if( finalExt )
				srcTag.setAttribute('type', "audio/" + getAudioType(finalExt));
			gAudioHTMLTag.setChildNodes(newChildNodes);
		}
		else
			return;
	}
	var updateText = gAudioHTMLTag .getOuterHTML();
	updateObjOuterHTML(updateText);
}

function setSource1()
{
	if(document.topLayer.document.source1.value && isAutoFillPossible("one") )
		autoFill(document.topLayer.document.source1.value);
	else
		setAudioSource( AUDIO_SRC1, document.topLayer.document.source1.value);
	if(document.topLayer.document.source1.value)
	{
		removeInlineSource();
	}
	else if(isOnlyInlineSourcePresent())
	{
		setInlineSourceAsPrimarySource();
	}	
}

function setSource2()
{
	var flagInlineSrcRemoval = false;
	if(isInlineSourcePresent())
	{
		flagInlineSrcRemoval = true;		
		setAudioSource( AUDIO_SRC1, getInlineSource());
	}
	if(document.bottomLayer.document.source2.value && isAutoFillPossible("two"))
		autoFill(document.bottomLayer.document.source2.value);
	else
		setAudioSource( AUDIO_SRC2, document.bottomLayer.document.source2.value);
	if(flagInlineSrcRemoval)	
	{
		removeInlineSource();
	}		
}

function setSource3()
{
	var flagInlineSrcRemoval = false;
	if(isInlineSourcePresent())
	{
		flagInlineSrcRemoval = true;		
		setAudioSource( AUDIO_SRC1, getInlineSource());
	}
	if(document.bottomLayer.document.source3.value && isAutoFillPossible("three"))
		autoFill(document.bottomLayer.document.source3.value);
	else	
		setAudioSource( AUDIO_SRC3, document.bottomLayer.document.source3.value);
	if(flagInlineSrcRemoval)	
	{
		removeInlineSource();
	}		
}

function setTitle()
{
	var title= document.topLayer.document.title.value;
    // Set the value of the direction attribute to theDirection. 
	setOrRemoveAttribute('title', title); 
}

function setControl()
{
	if(document.bottomLayer.document.controls.checked)
		modifyAudioTag();
	else
		removeAttr('controls');

}

function fillAttributes()
{
	var selectedNode = getSelectedNode();
	if(selectedNode)
	{
		var strout = "";
		var temp = selectedNode.getAttribute('id');
		if( temp && temp!="")
		{
			strout = strout + 'id="' + temp + '" ';
		}
		temp = selectedNode.getAttribute('class');
		if( temp && temp!="")
		{
			strout = strout + 'class="' + temp + '" ';
		}
		temp = selectedNode.getAttribute('src');
		if( temp && temp!="")
		{
			strout = strout + 'src="' + temp + '" ';
		}
		temp = selectedNode.getAttribute('title'); 
		if( temp && temp!="")
		{
			strout = strout + 'title="' + temp + '" ';
		}		
		temp = selectedNode.getAttribute('preload');
		if( temp && temp!="")
		{
			strout = strout + 'preload="' + temp + '" ';
		}
		if(document.bottomLayer.document.controls.checked)
		{
			strout = strout + 'controls="controls" ';
		}
		if(document.bottomLayer.document.muted.checked)
		{ 
			strout = strout + 'muted="muted" ';
		}
		if(document.bottomLayer.document.autoplay.checked)
		{ 
			strout = strout + 'autoplay="autoplay" ';
		}
		if(document.bottomLayer.document.loopAudio.checked)
		{ 
			strout = strout + 'loop="loop" ';
		}
		return strout;
	}
	return "";
}

function modifyAudioTag()
{
	var strout = "<audio ";
	strout = strout + fillAttributes();
	strout = strout + ">" ;
	var selectedNode = getSelectedNode();
	if( selectedNode )
	{
		var selNode = new TagEdit(selectedNode.outerHTML);
		var childNodes = selNode.getChildNodes();
		if(childNodes)
		{
			for(var i=0 ; i< childNodes.length ; i++ )
			{
				strout = strout + childNodes[i].getOuterHTML();
			}
		}
		strout = strout + "</audio>";
		if( selectedNode)
			selectedNode.outerHTML = strout;
	}
	
}
function setMuted()
{
	if(document.bottomLayer.document.muted.checked)
		modifyAudioTag();
	else
		removeAttr('muted');
}

function setAutoplay()
{
	if(document.bottomLayer.document.autoplay.checked)
		modifyAudioTag();
	else
		removeAttr('autoplay');
}
function setLoopAudio()
{
	if(document.bottomLayer.document.loopAudio.checked)
		modifyAudioTag();
	else
		removeAttr('loop');
}

function onPreLoadChange()
{
	// Get the index of the selected option in the pop-up menu 
    // in the interface. 
    var selIndex = document.bottomLayer.document.preload.selectedIndex; 
	// Update the tag
    var preloadval = document.bottomLayer.document.preload.options[selIndex].value;

	if( preloadval ){
		var theObj = getSelectedNode();
		if( theObj ){
			theObj.setAttribute('preload', preloadval);
			modifyAudioTag();
		}
	}
}

function onClassChange()
{
	// Get the index of the selected option in the pop-up menu 
	var theObj = getSelectedNode();
	if( theObj )
	{
		var classSel = document.getElementById('classList');
		
		var selIndex =  classSel.selectedIndex ;
		var classval = classSel.options[selIndex].value;
		if(classval && selIndex > 0)
		{
			theObj.setAttribute('class', classval);
			modifyAudioTag();
		}
		else
		{
			theObj.removeAttribute('class');
		}
	}    
}

function setaId()
{
	var idSel = document.getElementById('audioID');
    var theObj = getSelectedNode();
    if( theObj )
    {
        if(idSel.editText)
        {		
          var editObject = 
            {
                replaceID: idSel.editText
            };
        
          dw.applyIDToSelection(editObject);
          theObj.setAttribute('id', idSel.editText);
	  modifyAudioTag(); 
        }	
        else
        {
            theObj.removeAttribute('id');
        }
    }
}

function onIdChange()

{
	// Get the index of the selected option in the pop-up menu 
	var theObj = getSelectedNode();
	if( theObj )
	{
		var idSel = document.getElementById('audioID');
		var selIndex =  idSel.selectedIndex ;		
		if(selIndex >= 0)
		{
			var idval = idSel.options[selIndex].value;
			theObj.setAttribute('id', idval);			
			modifyAudioTag();
		}
	}    
}

function toggleCssFloater()
{
	dw.toggleFloater("CSS styles");
}

function browseForFile(srcField){

 var filePath = null;
 if( srcField ){
	 switch( srcField ){
		 case "one":
		 	filePath = document.topLayer.document.source1.value;
		 	break;
		 case "two":
		 	filePath =  document.bottomLayer.document.source2.value;
		 	break;
		 case "three":
		 	filePath =  document.bottomLayer.document.source3.value;
		 	break;	
		 default:
		 	break;
	 }
     var supportedMediaTypes = new Array("*.ogg; *.wav; *.mp3" );
     var selAudioStr = dw.loadString("Inspectors/audio/selectAudio");
	 
	 var  fileName= dw.browseForFileURL("select", selAudioStr, false, false, supportedMediaTypes, "", true, filePath );

	if( fileName ){
		if(!isKnownFormat(fileName)){
			alertUser();
			return;
		}
	}

	if (fileName) {
		  var fileURL = new File(fileName);
		  if(fileURL.exists())
		  { 
			  switch( srcField ){
	
				 case "one":				
					document.topLayer.document.source1.value = fileName;
					setSource1();
					break;
	
				 case "two":
				    	document.bottomLayer.document.source2.value = fileName;
				    	setSource2();
				    	break;
	
				 case "three":
					document.bottomLayer.document.source3.value = fileName;
					setSource3();
					break;
					 
				 default:
					break;
			 } // switch
			 
		  }
	 } // if( fileName ) 		 
 }// if srcField 
 
}
function isAutoFillPossible(srcField)
{
	switch( srcField ){
	
		case "one":
				if(!document.bottomLayer.document.source2.value && !document.bottomLayer.document.source3.value)	
					return true;
				
		case "two":
				if(!document.topLayer.document.source1.value && !document.bottomLayer.document.source3.value)	
					return true;
				
		case "three":
				if(!document.topLayer.document.source1.value && !document.bottomLayer.document.source2.value)	
					return true;
									
	    default:
			return false;
			
	} // switch
	return false;
}
function autoFill(fileName)
{	
	if(fileName)
	{
		var extArray = new Array(".ogg", ".wav", ".mp3");
		var lastIndex = fileName.lastIndexOf(".");
		if( lastIndex >=0 )
		{
			var head = fileName.substring(0,lastIndex);
			var ext = fileName.substring(lastIndex, fileName.length);
			var fileList = new Array();
			fileList.push(fileName);
					
			for(var i=0, count=1 ; i< extArray.length && count<3 ; i++)	
			{
				if(ext != extArray[i])
				{
					var tempFileName = head + extArray[i];
					var tempFile = new File(tempFileName);
					var encodedFileName = dw.doURLEncoding(tempFileName)
					if( tempFile.exists() && !isDuplicateAudio(encodedFileName) )
					{
						fileList.push(encodedFileName);				
						count++;
					}
				}
			}
			var childNodes = gAudioHTMLTag.getChildNodes();
			var newChildNodes = new Array();
			if( newChildNodes )
			{				
				for(var i=0 ; i<fileList.length ; i++ )
				{
					srcTag = new TagEdit("<source>");
						
					if(srcTag)
					{
						srcTag.setAttribute('src', fileList[i]);
						var extn = findExtension(fileList[i]);
						if( extn )
							srcTag.setAttribute('type', "audio/" + getAudioType(extn));			
							// find the position and set the new child			
							newChildNodes.push(srcTag);
					}
						
				}
				if(childNodes)
				{
					for( var i=0; i<childNodes.length; i++)
					{
						var tagName = childNodes[i].getTagName();
						if( tagName && tagName != "SOURCE" )
							newChildNodes.push(childNodes[i]);
					}
				}			
				gAudioHTMLTag.setChildNodes(newChildNodes)
				var updateText = gAudioHTMLTag .getOuterHTML();
				if( updateObjOuterHTML(updateText)) 
				{
					if(fileList && fileList.length == 3)	
					{
						updateUsageTrackingForAllSourcesUsed();
					}
				}
			}
		}
	}
}
function isDuplicateAudio(fileName)
{
	if( fileName == document.topLayer.document.source1.value || 
		fileName == document.bottomLayer.document.source2.value || 
		fileName == document.bottomLayer.document.source3.value   )
			return true; 
	
	return false;
}

function isOnlyInlineSourcePresent()
{
	var theDOM = dw.getDocumentDOM(); 
    	var theObj = getSelectedNode();
	if(document.topLayer.document.source1.value || document.bottomLayer.document.source2.value || document.bottomLayer.document.source3.value)
	{
		return false;
	}
	if(theObj && theObj.getAttribute('src'))
	{
		return true;
	}
	return false;	
}
function setInlineSourceAsPrimarySource()
{   
	var theObj = getSelectedNode();
	if(theObj)
		document.topLayer.document.source1.value = theObj.getAttribute('src');
}
function removeInlineSource()
{
	var theObj = getSelectedNode();
	if(theObj)
	{
		theObj.removeAttribute('src');
	}
}
function isInlineSourcePresent()
{
	var theObj = getSelectedNode();	
	if(theObj && theObj.getAttribute('src'))
	{
		return true;
	}
	return false;	
}

function getInlineSource()
{
	var theObj = getSelectedNode();	
	if(theObj )
		return theObj.getAttribute('src') ;
}